;;;   Programm:      ACM-UMBENENNENBKS.LSP
;;;   Befehlsaufruf: ACM-UMBENENNENBKS
;;;   Funktion:      Benutzerdefinierte Koordinatensysteme umbenennen
;;;   Autor:         Gerhard Rampf
;;;                  Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;;                  Liebigstr. 3 A
;;;                  86399 Bobingen
;;;                  E-Mail: rampf@geracad.de
;;;   Datum:         08.02.2025
;;;   Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-umbenennenbks ( / mda31 mda97 dma01 dma02 dma03 dma04 dma05 dma06 dma07 dma08 dma09 dma10 dma11 dma12 dma13 dma14 dma15 dma16 dma17 dma18 dma19 dma20 dma21 dma22 dma23 dma24 dma25 dma26 dma28 dma29 dma30 dma31 dma32)
    (defun dma01 (mda01 / )
      (if mda98 (vl-catch-all-apply 'setvar (list "CMDECHO" mda98)))
      (if mda97 (setq *error* mda97))
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
    (defun dma02 ( / mda25)
      (setq mda25 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= mda25 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq mda26 T)
            (setq mda26 nil)
        )
        (if (not mda26)
          (alert "\042acm-umbenennenbks\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      mda26
    )
    (defun dma03 (mda02 / mda27 mda28 mda29)
      (if (setq mda27 (dma28 mda02))
        (progn
          (if (setq mda28 (dma15 mda27 mda02))
            (progn
              (if (setq mda29 (dma06 mda27 mda28))
                (vl-catch-all-apply 'dma04 (list mda29 mda02))
                (prompt (strcat "\n*0 " "BKS " "wurde(n) umbenannt.* "))
              )
            )
          )
        )
        (dma12 "AUTOCAD Magazin" (strcat "Keine umbenennbaren " "BKS" " in\nder aktuellen Zeichnung vorhanden.") "34" "2.9")
      )
    )
    (defun dma04 (mda03 mda02 / mda30 mda31 mda32 mda33 mda34 mda35 mda36 mda37 mda38)
      (setq mda30 (vlax-get-acad-object))
      (setq mda31 (vla-get-ActiveDocument mda30))
      (setq mda32 (vlax-get mda31 'UserCoordinateSystems))
      (setq mda33 0)
      (setq mda34 0)
        (while mda03
          (setq mda35 (car mda03))
          (setq mda36 (car mda35))
          (setq mda37 (vl-string-trim " " (cdr mda35)))
            (if (dma05 mda37)
              (progn
                (setq mda38 (vla-Item mda32 mda36))
                  (if (= (type (vl-catch-all-apply 'vla-put-Name (list mda38 mda37))) 'VL-CATCH-ALL-APPLY-ERROR)
                    (setq mda33 (1+ mda33))
                    (progn
                      (if (/= mda36 mda37)
                        (setq mda34 (1+ mda34))
                      )
                    )
                  )
              )
            )
          (setq mda03 (cdr mda03))
        )
      (prompt (strcat "\n*" (itoa mda34) " BKS " "wurde(n) umbenannt.* "))
        (if (> mda33 0)
          (prompt (strcat "\n*" (itoa mda33) " " "BKS " "konnte(n) wegen Doppelvorkommens nicht umbenannt werden.* "))
        )
    )
    (defun dma05 (mda04 / mda39)
      (setq mda39 (strlen mda04))
        (if
          (and
            (< mda39 (nth (getvar "EXTNAMES") (list 32 256)))
            (snvalid mda04)
          )
            T
            nil
        )
    )
    (defun dma06 (mda05 mda06 / mda40 mda41 mda42 mda43 mda44 mda45 mda46 mda47)
      (setq mda40 (car mda06))
        (if (= (nth 4 mda06) "0")
          (progn
            (while mda40
              (setq mda41 (cons (nth (car mda40) mda05) mda41))
              (setq mda40 (cdr mda40))
            )
          )
          (setq mda41 mda05)
        )
      (setq mda42 (cadr mda06))
      (setq mda43 (caddr mda06))
      (setq mda44 (nth (atoi (cadddr mda06)) (list 1 0)))
        (while mda41
          (setq mda45 (car mda41))
            (if (setq mda46 (dma31 mda45 mda42 mda43 mda44))
              (setq mda47 (cons (cons mda45 mda46) mda47))
            )
          (setq mda41 (cdr mda41))
        )
      mda47
    )
    (defun dma07 (mda07 mda08 mda02 / mda48 mda49 mda50 mda51 mda53 mda52)
      (if (= mda08 "")
        (progn
          (dma12 "AUTOCAD Magazin" "Keine Eingabe fr \042Suchen nach\042." "29" "1.4")
          (mode_tile "eb_03" 2)
        )
        (progn
          (setq mda48 (mapcar 'strcase mda07))
          (setq mda49 (strcase mda08))
          (setq mda50 "")
          (setq mda51 -1)
          (setq mda52 0)
            (repeat (length mda48)
              (setq mda51 (1+ mda51))
                (if (wcmatch (nth mda51 mda48) mda49)
                  (progn
                    (setq mda50 (strcat mda50 (itoa mda51) " "))
                    (setq mda52 (1+ mda52))
                  )
                )
            )
            (if
              (and
                (<= mda52 250)
                (/= (setq mda53 (vl-string-trim " " mda50)) "")
              )
                (progn
                  (set_tile "lb_01" "")
                  (set_tile "lb_01" mda53)
                  (setq mda54 mda53)
                )
                (progn
                  (set_tile "lb_01" "0")
                  (set_tile "lb_01" "")
                  (setq mda54 "")
                    (if (> mda52 250)
                      (dma12 "AUTOCAD Magazin" (strcat "Ungltige Auswahl. Mehr als 250 ent-\nsprechende " "BKS" " gefunden.") "32" "2.9")
                      (dma12 "AUTOCAD Magazin" (strcat "Es wurden keine entsprechenden\n" "BKS" " gefunden.") "30" "2.9")
                    )
                  (mode_tile "eb_03" 2)
                )
            )
        )
      )
    )
    (defun dma08 (mda09 mda02 / )
      (if (= $value "1")
        (progn
          (set_tile "lb_01" "0 1 2 3 4 5 6 7 8 9 10 11 12")
          (mode_tile "lb_01" 1)
          (mode_tile "b_00" 1)
          (mode_tile "eb_03" 1)
          (set_tile "t_00" (strcat (itoa (length mda09)) " " "BKS " "gewhlt"))
        )
        (progn
          (set_tile "lb_01" "0")
          (set_tile "lb_01" "")
            (if (not mda54)
              (setq mda54 "")
            )
          (set_tile "lb_01" mda54)
          (mode_tile "lb_01" 0)
          (mode_tile "b_00" 0)
          (mode_tile "eb_03" 0)
          (set_tile "t_00" (strcat (itoa (length (dma11 mda54 " "))) " " "BKS " "gewhlt"))
        )
      )
    )
    (defun dma09 (mda10 mda11 / mda55 mda56 mda35 mda57)
      (setq mda55 (strlen mda10))
      (setq mda56 1)
        (while (<= mda56 mda55)
          (setq mda35 (substr mda10 mda56 1))
            (if (/= mda35 mda11)
              (progn
                (setq mda57 nil)
                (setq mda56 (1+ mda56))
              )
            )
            (if (= mda35 mda11)
              (progn
                (setq mda57 mda56)
                (setq mda56 (1+ mda55))
              )
            )
        )
      mda57
    )
    (defun dma10 (mda10 mda12 / mda55 mda35 mda51 mda58)
      (setq mda55 (strlen mda10))
      (setq mda35 (substr mda10 1 1))
      (setq mda51 0)
        (while
          (and
            (/= (member mda35 mda12) nil)
            (/= mda51 mda55)
          )
            (setq mda10 (substr mda10 2))
            (setq mda35 (substr mda10 1 1))
            (setq mda51 (+ mda51 1))
        )
        (if (/= mda51 mda55)
          (progn
            (setq mda55 (strlen mda10))
            (setq mda58 (substr mda10 mda55 1))
            (setq mda51 mda55)
              (while
                (and
                  (/= (member mda58 mda12) nil)
                  (/= mda51 0)
                )
                  (setq mda10 (substr mda10 1 mda51))
                  (setq mda58 (substr mda10 mda51 1))
                  (setq mda51 (- mda51 1))
              )
          )
        )
      mda10
    )
    (defun dma11 (mda13 mda14 / mda59 mda57 mda60 mda26)
      (if
        (and
          (= (type mda13) 'STR)
          (= (type mda14) 'STR)
        )
          (progn
            (setq mda59 (dma10 mda13 (list mda14)))
            (setq mda57 (dma09 mda59 mda14))
              (if mda57
                (progn
                  (setq mda60 (substr mda59 1 (1- mda57)))
                  (setq mda59 (dma10 (substr mda59 (1+ (strlen mda60))) (list mda14)))
                  (setq mda26 (cons mda60 mda26))
                )
              )
            (setq mda57 (dma09 mda59 mda14))
              (while mda57
                (setq mda60 (substr mda59 1 (1- mda57)))
                (setq mda59 (dma10 (substr mda59 (1+ (strlen mda60))) (list mda14)))
                (setq mda26 (cons mda60 mda26))
                (setq mda57 (dma09 mda59 mda14))
              )
              (if (> (strlen mda59) 0)
                (setq mda26 (cons mda59 mda26))
              )
          )
      )
      (if mda26
        (reverse mda26)
        nil
      )
    )
    (defun dma12 (mda15 mda16 mda17 mda18 / mda61 mda62)
        (if (setq mda61 (dma13 mda17 mda18))
          (progn
            (setq mda62 (load_dialog mda61))
              (if (not (new_dialog "alert" mda62))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list mda61))
            (set_tile "t_2" mda16)
            (set_tile "t_1" "AUTOCAD Magazin")
            (action_tile "b_1" "(done_dialog)")
            (start_dialog)
            (unload_dialog mda62)
          )
        )
    )
    (defun dma13 (mda17 mda18 / mda65 mda63 mda64)
      (if
        (and
          (setq mda63 (vl-filename-mktemp "acm.dcl"))
          (setq mda64 (open mda63 "w"))
        )
          (progn
            (setq mda65
              (list
                "alert"
                ":dialog{"
                "key=\042t_1\042;"
                ":spacer{"
                "height=0.1;"
                "}"
                ":text{"
                "alignment=top;"
                "key=\042t_2\042;"
                (strcat "width=" mda17 ";")
                (strcat "height=" mda18 ";")
                "fixed_width=true;"
                "fixed_height=true;"
                "}"
                ":row{"
                ":spacer{"
                "width=5;"
                "}"
                ":button{"
                "label=\042OK\042;"
                "key=\042b_1\042;"
                "width=13;"
                "fixed_width=true;"
                "is_cancel=true;"
                "}"
                ":spacer{"
                "width=5;"
                "}"
                "}"
                "}"
              )
            )
            (while mda65
              (write-line (car mda65) mda64)
              (setq mda65 (cdr mda65))
            )
            (setq mda64 (close mda64))
            mda63
          )
          nil
      )
    )
    (defun dma14 (mda09 mda02 / )
      (if (= $reason 1)
        (progn
          (set_tile $key (setq mda66 (vl-string-trim " " $value)))
          (dma07 mda09 mda66 mda02)
          (set_tile "t_00" (strcat (itoa (length (dma11 (get_tile "lb_01") " "))) " " "BKS " "gewhlt"))
        )
      )
    )
    (defun dma15 (mda09 mda02 / mda61 mda62 mda26)
        (if (setq mda61 (dma25 mda02))
          (progn
            (setq mda62 (load_dialog mda61))
              (if (not (new_dialog "acmrenameucs" mda62))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list mda61))
            (start_list "lb_01")
            (mapcar 'add_list mda09)
            (end_list)
            (mode_tile "lb_01" 2)
            (set_tile "t_00" (strcat (itoa (length (dma11 (get_tile "lb_01") " "))) " " "BKS " "gewhlt"))
            (set_tile "eb_01" (dma24))
            (set_tile "eb_02" (dma23))
            (set_tile "tg_01" (dma22))
            (action_tile "lb_01" "(dma20 \"BKS \")")
            (action_tile "tg_00" "(dma08 mda09 mda02)")
            (action_tile "b_00" "(dma16 mda09 mda02)")
            (action_tile "eb_03" "(dma14 mda09 mda02)")
            (action_tile "b_01" "(setq mda26 (dma17 mda02))")
            (action_tile "b_02" "(setq mda26 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog mda62)
          )
        )
      mda26
    )
    (defun dma16 (mda09 mda02 / mda67)
      (set_tile "eb_03" (setq mda67 (vl-string-trim " " (get_tile "eb_03"))))
      (dma07 mda09 mda67 mda02)
      (set_tile "t_00" (strcat (itoa (length (dma11 (get_tile "lb_01") " "))) " " "BKS " "gewhlt"))
    )
    (defun dma17 (mda02 / mda71 mda70 mda72 mda73)
      (setq mda68 (dma11 (setq mda69 (get_tile "lb_01")) " "))
      (setq mda68 (mapcar 'atoi mda68))
        (if (< (length mda68) 1)
          (progn
            (dma12 "AUTOCAD Magazin" (strcat "Bitte mindestens " "ein umzube-\nnennendes BKS" " whlen.") "28.5" "2.9")
            (mode_tile "lb_01" 2)
            (setq mda70 0)
          )
          (setq mda70 1)
        )
        (if (= mda70 1)
          (progn
            (setq mda71 (get_tile "eb_01"))
              (if (= (getvar "EXTNAMES") 0)
                (progn
                  (if (= (vl-string-trim " " mda71) "")
                    (progn
                      (dma12 "AUTOCAD Magazin" "Keine gltige Eingabe fr \042Ersetzen\042." "31" "1.9")
                      (setq mda70 0)
                      (set_tile "eb_01" "")
                      (mode_tile "eb_01" 2)
                    )
                  )
                )
                (progn
                  (if (= mda71 "")
                    (progn
                      (dma12 "AUTOCAD Magazin" "Keine gltige Eingabe fr \042Ersetzen\042." "31" "1.9")
                      (setq mda70 0)
                      (mode_tile "eb_01" 2)
                    )
                  )
                )
              )
          )
        )
        (if (= mda70 1)
          (progn
            (if (setq mda72 (dma18))
              (setq mda70 1)
              (setq mda70 0)
            )
          )
        )
        (if (= mda70 1)
          (progn
            (setq mda73 (list mda68 (setq mda74 (get_tile "eb_01")) (setq mda75 (get_tile "eb_02")) (setq mda76 (get_tile "tg_01")) (get_tile "tg_00")))
            (done_dialog)
          )
        )
      mda73
    )
    (defun dma18 ( / mda66 mda77)
      (setq mda66 (get_tile "eb_02"))
        (if (not (dma19 mda66))
          (progn
            (dma29 "Ungltige Eingabe fr \042Mit\042" (list "31" "255"))
            (mode_tile "eb_02" 2)
            (setq mda77 nil)
          )
          (setq mda77 mda66)
        )
      mda77
    )
    (defun dma19 (mda04 / mda77)
        (if (= (getvar "EXTNAMES") 0)
          (progn
            (if
              (or
                (= mda04 "")
                (snvalid mda04)
              )
                (setq mda77 T)
                (setq mda77 nil)
            )
          )
          (progn
            (setq mda04 (vl-string-trim " " mda04))
              (if
                (or
                  (= mda04 "")
                  (snvalid mda04)
                )
                  (setq mda77 T)
                  (setq mda77 nil)
              )
          )
        )
      mda77
    )
    (defun dma20 (mda19 / )
        (if (> (length (dma11 (setq mda54 $value) " ")) 250) 
          (progn 
            (dma12 "AUTOCAD Magazin" "Ungltige Auswahl. Bitte maximal 250 Eintrge whlen." "25.5" "2.4")
            (set_tile $key "0")
            (set_tile $key "")
            (setq mda54 "")
          ) 
        )
      (set_tile "t_00" (strcat (itoa (length (dma11 mda54 " "))) " " mda19 "gewhlt"))
    )
    (defun dma21 (mda09 mda02 / mda67 mda78)
      (setq mda67 (get_tile "eb_01"))
      (setq mda78 (dma26 mda09 mda67 (atoi (get_tile "tg_01"))))
        (if (< (length (caddr mda78)) 251)
          (progn
            (if (= (car mda78) 1)
              (progn
                (if (not (caddr mda78))
                  (progn
                    (dma12 "AUTOCAD Magazin" (strcat "Es wurden keine entsprechenden " "BKS" " gefunden.") "39.5" "2.4")
                    (set_tile "lb_01" "0")
                    (set_tile "lb_01" "")
                    (mode_tile "eb_01" 2)
                  )
                  (progn
                    (set_tile "lb_01" "")
                    (set_tile "lb_01" (cadr mda78))
                  )
                )
              (set_tile "t_01" (strcat (itoa (length (caddr mda78))) " " "BKS " "gewhlt"))
              )
            )
          )
          (progn
            (dma12 "AUTOCAD Magazin" "Ungltig. Mehr als 250 Eintrge gefunden." "35" "1.4")
            (set_tile "lb_01" "0")
            (set_tile "lb_01" "")
            (set_tile "t_01" (strcat "0 " "BKS " "gewhlt"))
          )
        )
    )
    (defun dma22 ( / )
      (if (vl-position mda76 (list "0" "1"))
        mda76
        "0"
      )
    )
    (defun dma23 ( / mda26)
        (if (= (getvar "EXTNAMES") 0)
          (progn
            (if
              (and
                (= (type mda75) 'STR)
                (snvalid mda75)
              )
                (setq mda26 mda75)
                (setq mda26 "")
            )
          )
          (progn
            (if
              (and
                (= (type mda75) 'STR)
                (or
                  (snvalid (vl-string-trim " " mda75))
                  (= (vl-string-trim " " mda75) "")
                )
              )
                (setq mda26 mda75)
                (setq mda26 "")
            )
          )
        )
      mda26
    )
    (defun dma24 ( / mda26)
        (if (= (getvar "EXTNAMES") 0)
          (progn
            (if
              (and
                (= (type mda74) 'STR)
                (snvalid mda74)
              )
                (setq mda26 mda74)
                (setq mda26 "")
            )
          )
          (progn
            (if
              (and
                (= (type mda74) 'STR)
                (or
                  (snvalid (vl-string-trim " " mda74))
                  (= (vl-string-trim " " mda74) "")
                )
              )
                (setq mda26 mda74)
                (setq mda26 "")
            )
          )
        )
      mda26
    )
    (defun dma25 (mda02 / mda63 mda64 mda65)
      (if
        (and
          (setq mda63 (vl-filename-mktemp "acm.dcl"))
          (setq mda64 (open mda63 "w"))
        )
          (progn
            (setq mda65
              (list
                "acmrenameucs"
                ":dialog{"
                (strcat "label=\042" "BKS" " umbenennen\042;")
                ":spacer{"
                "height=0.0;"
                "}"
                ":text{"
                (strcat "label=\042" "BKS" " &whlen:\042;")
                "}"
                ":list_box{"
                "key=\042lb_01\042;"
                "width=30;"
                "height=12;"
                "multiple_select=true;"
                "}"
                ":text{key=\"t_00\";}"
                ":row{"
                ":button{"
                "key=\042b_00\042;"
                "label=\042&Suchen nach:\042;"
                "width=0;fixed_width=true;"
                "}"
                ":edit_box{"
                "key=\042eb_03\042;width=15;"
                "}"
                "}"
                ":toggle{"
                "key=\"tg_00\";"
                "label=\"&Alle whlen\";"
                "}"
                ":spacer{"
                "height=0.7;"
                "}"
                ":row{"
                ":column{"
                "width=25;"
                ":row{"
                (strcat ":edit_box{key=\042eb_01\042;label=\042&Ersetzen:\042;edit_width=21;edit_limit=" (nth (getvar "EXTNAMES") (list "31" "255")) ";}")
                "}"
                (strcat ":edit_box{key=\042eb_02\042;label=\042&Mit:\042;edit_width=21;edit_limit=" (nth (getvar "EXTNAMES") (list "31" "255")) ";}}}")
                ":spacer{"
                "height=0.2;"
                "}"
                ":toggle{"
                "key=\042tg_01\042;"
                "label=\042Gro-/Kleins&chreibung beachten\042;"
                "}"
                ":spacer{"
                "height=0.3;"
                "}"
                ":row{"
                ":spacer{"
                "width=5;"
                "}"
                ":column{"
                "width=0;"
                ":button{"
                "key=\042b_01\042;"
                "label=\042OK\042;"
                "is_default=true;"
                "}"
                ":button{"
                "key=\042b_02\042;"
                "label=\042Abbrechen\042;"
                "is_cancel=true;"
                "}"
                "}"
                ":spacer{"
                "width=5;"
                "}"
                "}"
                "}"
              )
            )
              (while mda65
                (write-line (car mda65) mda64)
                (setq mda65 (cdr mda65))
              )
            (setq mda64 (close mda64))
            mda63
          )
          nil
      )
    )
    (defun dma26 (mda03 mda19 mda20 / mda26 mda79 mda42 mda80 mda51 mda35 mda52 mda81 dma27)
        (defun dma27 (mda10 / )
          (strcase mda10 1)
        )
        (if
          (and
            (= (getvar "EXTNAMES") 0)
            (= (vl-string-trim " " mda19) "")
          )
            (progn
              (dma12 "AUTOCAD Magazin" "Keine gltige Eingabe fr \042Ersetzen\042." "31" "1.9")
              (set_tile "eb_01" "")
              (mode_tile "eb_01" 2)
              (setq mda26 (list 0))
            )
            (progn
              (if (= mda19 "")
                (progn
                  (dma12 "AUTOCAD Magazin" "Keine gltige Eingabe fr \042Ersetzen\042." "31" "1.9")
                  (mode_tile "eb_01" 2)
                  (setq mda26 (list 0))
                )
                (progn
                    (if (= mda20 0)
                      (progn
                        (setq mda79 (mapcar 'acmbks_Subr01 mda03))
                        (setq mda42 (strcase mda19 1))
                      )
                      (progn
                        (setq mda79 mda03)
                        (setq mda42 mda19)
                      )
                    )
                  (setq mda80 "")
                  (setq mda51 -1)
                    (while mda79
                      (setq mda51 (1+ mda51))
                      (setq mda35 (car mda79))
                        (if (vl-string-search mda42 mda35)
                          (progn
                            (setq mda80 (strcat mda80 " " (itoa mda51)))
                            (setq mda52 (cons mda35 mda52))
                            (setq mda81 (cons (nth mda51 mda03) mda81))
                          )
                        )
                      (setq mda79 (cdr mda79))
                    )
                  (setq mda80 (vl-string-trim " " mda80))
                  (setq mda52 (reverse mda52))
                  (setq mda81 (reverse mda81))
                  (setq mda26 (list 1 mda80 mda52 mda81))
                )
              )
            )
        )
      mda26
    )
    (defun dma28 (mda02 / mda30 mda31 mda82 mda83 mda41 mda00)
      (setq mda30 (vlax-get-acad-object))
      (setq mda31 (vla-get-ActiveDocument mda30))
      (setq mda82 'UserCoordinateSystems)
      (setq mda83 (vlax-get mda31 mda82))
        (vlax-for mda00 mda83
          (setq mda84 (vlax-get mda00 'Name))
            (if
              (and
                (= mda02 0)
                (/= mda84 "0")
                (not (vl-string-search "|" mda84))
              )
                (setq mda41 (cons (vlax-get mda00 'Name) mda41))
            )
        )
        (if mda41
          (setq mda77 (acad_strlsort mda41))
          (setq mda77 nil)
        )
      mda77
    )
    (defun dma29 (mda16 mda21 / mda61 mda62 mda85 mda86 mda51 mda87)
        (if (setq mda61 (dma30))
          (progn
            (setq mda62 (load_dialog mda61))
              (if (not (new_dialog "warn" mda62))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list mda61))
            (setq mda85 '((25 14 25 17 8) (6 33 27 33 8) (5 32 27 32 8) (3 30 26 30 2) (2 27 13 27 2) (2 26 13 26 2) (3 25 13 25 2) (3 24 13 24 2) (4 23 26 23 2) (4 22 14 22 2) (5 21 13 21 2) (5 20 13 20 2) (6 19 13 19 2) (2 29 27 29 2) (2 28 28 28 2) (4 31 27 31 -16) (3 31 3 31 54) (2 30 2 30 54) (1 26 1 29 54) (6 18 12 18 2) (6 16 6 17 54) (5 18 5 19 54) (2 24 2 25 54) (3 22 3 23 54) (4 20 4 21 54) (7 17 12 17 2) (7 16 12 16 2) (18 27 28 27 2) (18 26 27 26 2) (18 25 27 25 2) (18 24 26 24 2) (15 27 16 27 -16) (14 26 17 26 -16) (18 17 23 17 2) (18 16 22 16 2) (17 20 24 20 2) (17 19 24 19 2) (18 18 23 18 2) (16 22 25 22 2) (17 21 25 21 2) (17 17 17 17 54) (13 17 13 17 54) (14 17 16 17 -16) (13 16 17 16 -16) (16 20 16 20 54) (14 20 14 20 54) (14 19 16 19 -16) (14 18 16 18 -16) (14 25 17 25 -16) (15 24 16 24 -16) (15 22 15 20 -16) (24 16 24 17 -16) (25 18 25 19 -16) (30 24 30 33 8) (28 31 28 33 8) (29 30 29 33 8) (32 28 32 31 8) (28 30 28 30 -16) (31 26 31 32 8) (29 26 29 29 -16) (29 22 29 25 8) (28 24 28 25 -16) (27 22 27 23 -16) (28 20 28 23 8) (27 18 27 21 8) (26 20 26 21 -16) (26 16 26 19 8) (12 7 18 7 2) (12 6 17 6 2) (10 10 19 10 2) (11 9 19 9 2) (11 8 18 8 2) (11 6 11 7 54) (8 12 8 13 54) (9 10 9 11 54) (10 8 10 9 54) (8 14 12 14 2) (9 13 12 13 2) (9 12 12 12 2) (10 11 12 11 2) (8 15 12 15 2) (7 14 7 15 54) (12 4 12 5 54) (20 5 20 7 8) (18 14 21 14 2) (18 13 21 13 2) (18 12 20 12 2) (18 11 20 11 2) (18 15 22 15 2) (19 6 19 7 -16) (13 14 17 14 -16) (13 13 17 13 -16) (13 12 17 12 -16) (14 11 16 11 -16) (13 15 17 15 -16) (23 10 23 13 8) (22 8 22 11 8) (22 12 22 13 -16) (21 10 21 11 -16) (20 8 20 9 -16) (24 12 24 15 8) (23 14 23 15 -16) (21 6 21 9 8) (19 4 19 5 8) (13 5 17 5 2) (13 4 16 4 2) (14 3 15 3 2) (18 4 18 5 -16) (17 3 17 3 -16) (13 3 13 3 54) (14 2 16 2 54)))
            (setq mda86 (length mda85))
            (setq mda51 0)
            (start_image "i_1")
              (while (< mda51 mda86)
                (setq mda87 (car mda85))
                (setq mda85 (cdr mda85))
                (vector_image (nth 0 mda87) (nth 1 mda87) (nth 2 mda87) (nth 3 mda87) (nth 4 mda87))
                (setq mda51 (1+ mda51))
              )
            (end_image)
            (set_tile "t_2" (strcat mda16 "\n\nDie maximal erlaubte Zeichenzahl\nbetrgt " (nth (getvar "EXTNAMES") mda21) ". Folgende Zeichen " (nth (getvar "EXTNAMES") (list "drfen\nverwendet werden:\n                   A - Z\n                   0 - 9\n                   $ _ -" "drfen\nnicht verwendet werden:\n\n         < >/ \\ \042 : ; ? * | , = `"))))
            (set_tile "t_1" "AUTOCAD Magazin")
            (action_tile "b_1" "(done_dialog)")
            (start_dialog)
            (unload_dialog mda62)
          )
        )
    )
    (defun dma30 ( / mda65 mda63 mda64)
      (if
        (and
          (setq mda63 (vl-filename-mktemp "acm.dcl"))
          (setq mda64 (open mda63 "w"))
        )
          (progn
            (setq mda65
              (list
                "warn"
                ":dialog{"
                "key=\042t_1\042;"
                ":spacer{"
                "height=0.1;"
                "}"
                ":row{"
                ":image{"
                "alignment=top;"
                "color=dialog_background;"
                "key=\042i_1\042;"
                "width=5.5;"
                "height=2.7;"
                "fixed_width=true;"
                "fixed_height=true;"
                "}"
                ":spacer{"
                "width=0.05;"
                "}"
                ":text{"
                "alignment=top;"
                "key=\042t_2\042;"
                "width=32;"
                (nth (getvar "EXTNAMES") (list "height=8.4;" "height=7.4;"))
                "fixed_width=true;"
                "fixed_height=true;"
                "}"
                "}"
                ":row{"
                ":spacer{"
                "width=5;"
                "}"
                ":button{"
                "label=\042OK\042;"
                "key=\042b_1\042;"
                "width=13;"
                "fixed_width=true;"
                "is_cancel=true;"
                "}"
                ":spacer{"
                "width=5;"
                "}"
                "}"
                "}"
              )
            )
            (while mda65
              (write-line (car mda65) mda64)
              (setq mda65 (cdr mda65))
            )
            (setq mda64 (close mda64))
            mda63
          )
          nil
      )
    )
    (defun dma31 (mda22 mda19 mda23 mda20 / mda88 mda90 mda91 mda92 mda89)
        (if
          (and
            (= (type mda22) 'STR)
            (= (type mda19) 'STR)
            (= (type mda23) 'STR)
            (= (type mda20) 'INT)
          )
            (progn
              (setq mda88 mda22)
              (setq mda89 "")
                (while (setq mda90 (dma32 mda22 mda19 mda20))
                  (setq mda91 (substr mda22 1 (1- (car mda90))))
                  (setq mda92 (substr mda22 (1+ (cadr mda90))))
                  (setq mda89 (strcat mda89 mda91 mda23))
                  (setq mda22 mda92)
                )
                (if
                  (and
                    mda89
                    mda92
                  )
                    (setq mda22 (strcat mda89 mda92))
                )
                (if (= mda22 mda88)
                  (setq mda26 nil)
                  (setq mda26 mda22)
                )
            )
            (setq mda26 nil)
        )
      mda26
    )
    (defun dma32 (mda22 mda24 mda20 / mda93 mda51 mda94 mda95 mda96 mda52)
      (setq mda93 mda24)
        (if
          (and
            (= (type mda22) 'STR)
            (= (type mda24) 'STR)
            (= (type mda20) 'INT)
          )
            (progn
              (setq mda94 (strlen mda24))
              (setq mda95 (strlen mda22))
                (if
                  (and
                    (<= mda94 mda95)
                    (not (equal mda22 ""))
                    (not (equal mda24 ""))
                  )
                    (progn
                      (setq mda51 1)
                        (setq mda96 (substr mda22 mda51 mda94))
                          (if (> mda20 0)
                            (progn
                              (setq mda93 (strcase mda93))
                              (setq mda96 (strcase mda96))
                            )
                          )
                          (if (equal mda96 mda93)
                            (setq mda52 T)
                          )
                          (while
                            (and
                              (not mda52)
                              (not (equal mda96 mda93))
                              (>= (- mda95 mda51) mda94)
                            )
                              (setq mda52 nil)
                              (setq mda51 (1+ mda51))
                              (setq mda96 (substr mda22 mda51 mda94))
                                (if (> mda20 0)
                                  (setq mda96 (strcase mda96))
                                )
                                (if (equal mda96 mda93)
                                  (setq mda52 T)
                                )
                          )
                          (if mda52
                            (list mda51 (1- (+ mda51 mda94)))
                            nil
                          )
                    )
                    nil
                )
            )
            nil
        )
    )
  (if (dma02)
    (progn
      (vl-load-com)
      (sssetfirst nil nil)
      (setq mda31 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq mda97 *error*)
      (setq *error* dma01)
      (vla-EndUndoMark mda31)
      (vla-StartUndoMark mda31)
      (dma03 0)
        (if mda97
          (setq *error* mda97)
          (setq *error* nil)
        )
      (vla-EndUndoMark mda31)
    )
  )
  (princ)
)
(terpri)
(princ (strcat "\nAutoLISP-Tool ACM-UMBENENNENBKS (Copyright  " (substr (rtos (getvar "CDATE")) 1 4) " Gerhard Rampf) geladen. "))
(princ "\nRufen Sie den Befehl mit ACM-UMBENENNENBKS auf.")
